class NeutralMutator extends Mutator;

var bool bNeutralOn;

function PostBeginPlay()
{   
	Level.Game.BaseMutator.AddMutator(Self);
	Level.Game.RegisterDamageMutator(Self);
}

function MutatorTakeDamage(out int ActualDamage, Pawn Victim, Pawn InstigatedBy, out Vector HitLocation, out Vector Momentum, name DamageType)
{
               if (bNeutralOn)
               {
		if ((Victim.Region.Zone.bNeutralZone) || (InstigatedBy.Region.Zone.bNeutralZone))
		{
			ActualDamage = 0;
                        InstigatedBy.ClientMessage("|p2You are in a NO KILLING ZONE!");
		}
		if ((Victim.Region.Zone.IsA('ZoneInfo')) && (Victim.Region.Zone.bNeutralZone) && (!InstigatedBy.Region.Zone.bNeutralZone))
		{
			ActualDamage = 0;
                        InstigatedBy.ClientMessage("|p2They are in a NO KILLING ZONE!");
		}
               }
	Super.MutatorTakeDamage(ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType);
}

function Mutate(string S, PlayerPawn Player)
{
 if (S ~= "Neutral")
 {
  if (Player.bAdmin)
  {
   if (!bNeutralOn)
   {
    BroadcastMessage("|p3A local admin has turned on the neutral zones!");
    bNeutralOn = True;
    return;
   }
   if (bNeutralOn)
   {
    BroadcastMessage("|p2A local admin has turned off the neutral zones.");
    bNeutralOn = False;
    return;
   }
  }
  else
  {
   Player.ClientMessage("|p2This command is for admins only.");
   return;
  }
 }
 Super.Mutate(S, Player);
}

defaultproperties
{
}